#include <GDIPlus.au3>

_GDIPlus_Startup()

Local $sSourceImageFileName = @ScriptDir & "\TestImage.png"
Local $sTestOldScaleFileName = @ScriptDir & "\TestOldScale.png"
Local $sTestNewScaleFileName = @ScriptDir & "\TestNewScale.png"
Local $sTestOldResizeFileName = @ScriptDir & "\TestOldResize.png"
Local $sTestNewResizeFileName = @ScriptDir & "\TestNewResize.png"

Local $hImage = _GDIPlus_ImageLoadFromFile($sSourceImageFileName)
Local $iSourceWidth = _GDIPlus_ImageGetWidth($hImage)
Local $iSourceHeight = _GDIPlus_ImageGetHeight($hImage)

Local $hBitmapOldScale = _GDIPlus_ImageScale($hImage, 4, 4, $GDIP_INTERPOLATIONMODE_HIGHQUALITYBICUBIC)
_GDIPlus_ImageSaveToFile($hBitmapOldScale, $sTestOldScaleFileName) ; also frees bitmap by default

Local $hBitmapNewScale = My_GDIPlus_ImageScale($hImage, 4, 4, $GDIP_INTERPOLATIONMODE_HIGHQUALITYBICUBIC)
_GDIPlus_ImageSaveToFile($hBitmapNewScale, $sTestNewScaleFileName) ; also frees bitmap by default

Local $hBitmapOldResize = _GDIPlus_ImageResize($hImage, $iSourceWidth * 4, $iSourceHeight * 4, $GDIP_INTERPOLATIONMODE_HIGHQUALITYBICUBIC)
_GDIPlus_ImageSaveToFile($hBitmapOldResize, $sTestOldResizeFileName) ; also frees bitmap by default

Local $hBitmapNewResize = My_GDIPlus_ImageResize($hImage, $iSourceWidth * 4, $iSourceHeight * 4, $GDIP_INTERPOLATIONMODE_HIGHQUALITYBICUBIC)
_GDIPlus_ImageSaveToFile($hBitmapNewResize, $sTestNewResizeFileName) ; also frees bitmap by default

_GDIPlus_ImageDispose($hImage)
_GDIPlus_Shutdown()

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Test these functions as potential replacements for those GDIPlus.au3

Func My_GDIPlus_ImageResize($hImage, $iNewWidth, $iNewHeight, $iInterpolationMode = $GDIP_INTERPOLATIONMODE_HIGHQUALITYBICUBIC)
	Local $iOldWidth = _GDIPlus_ImageGetWidth($hImage)
	If @error Then Return SetError(1, 0, 0)
	Local $iOldHeight = _GDIPlus_ImageGetHeight($hImage)
	If @error Then Return SetError(2, 0, 0)
	Local $hBitmap = _GDIPlus_BitmapCreateFromScan0($iNewWidth, $iNewHeight)
	If @error Then Return SetError(3, 0, 0)
	Local $hGraphics = _GDIPlus_ImageGetGraphicsContext($hBitmap)
	If @error Then
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(4, 0, 0)
	EndIf
	Local $hAttributes = _GDIPlus_ImageAttributesCreate()
	If @error Then
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(5, 0, 0)
	EndIf
	My_GDIPlus_ImageAttributesSetWrapMode($hAttributes, 3)
	If @error Then
		_GDIPlus_ImageAttributesDispose($hAttributes)
		_GDIPlus_GraphicsDispose($hGraphics)
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(6, 0, 0)
	EndIf
	_GDIPlus_GraphicsSetInterpolationMode($hGraphics, $iInterpolationMode)
	If @error Then
		_GDIPlus_ImageAttributesDispose($hAttributes)
		_GDIPlus_GraphicsDispose($hGraphics)
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(7, 0, 0)
	EndIf
	_GDIPlus_GraphicsDrawImageRectRect($hGraphics, $hImage, 0, 0, $iOldWidth, $iOldHeight, 0, 0, $iNewWidth, $iNewHeight, $hAttributes)
	If @error Then
		_GDIPlus_ImageAttributesDispose($hAttributes)
		_GDIPlus_GraphicsDispose($hGraphics)
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(8, 0, 0)
	EndIf
	_GDIPlus_ImageAttributesDispose($hAttributes)
	_GDIPlus_GraphicsDispose($hGraphics)
	Return $hBitmap
EndFunc   ;==>My_GDIPlus_ImageResize

Func My_GDIPlus_ImageScale($hImage, $iScaleW, $iScaleH, $iInterpolationMode = $GDIP_INTERPOLATIONMODE_HIGHQUALITYBICUBIC)
	Local $iOldWidth = _GDIPlus_ImageGetWidth($hImage)
	Local $iNewWidth = $iOldWidth * $iScaleW
	If @error Then Return SetError(1, 0, 0)
	Local $iOldHeight = _GDIPlus_ImageGetHeight($hImage)
	Local $iNewHeight = $iOldHeight * $iScaleH
	If @error Then Return SetError(2, 0, 0)
	Local $hBitmap = _GDIPlus_BitmapCreateFromScan0($iNewWidth, $iNewHeight)
	If @error Then Return SetError(3, 0, 0)
	Local $hGraphics = _GDIPlus_ImageGetGraphicsContext($hBitmap)
	If @error Then
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(4, 0, 0)
	EndIf
	Local $hAttributes = _GDIPlus_ImageAttributesCreate()
	If @error Then
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(5, 0, 0)
	EndIf
	My_GDIPlus_ImageAttributesSetWrapMode($hAttributes, 3)
	If @error Then
		_GDIPlus_ImageAttributesDispose($hAttributes)
		_GDIPlus_GraphicsDispose($hGraphics)
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(6, 0, 0)
	EndIf
	_GDIPlus_GraphicsSetInterpolationMode($hGraphics, $iInterpolationMode)
	If @error Then
		_GDIPlus_ImageAttributesDispose($hAttributes)
		_GDIPlus_GraphicsDispose($hGraphics)
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(7, 0, 0)
	EndIf
	_GDIPlus_GraphicsDrawImageRectRect($hGraphics, $hImage, 0, 0, $iOldWidth, $iOldHeight, 0, 0, $iNewWidth, $iNewHeight, $hAttributes)
	If @error Then
		_GDIPlus_ImageAttributesDispose($hAttributes)
		_GDIPlus_GraphicsDispose($hGraphics)
		_GDIPlus_BitmapDispose($hBitmap)
		Return SetError(8, 0, 0)
	EndIf
	_GDIPlus_ImageAttributesDispose($hAttributes)
	_GDIPlus_GraphicsDispose($hGraphics)
	Return $hBitmap
EndFunc   ;==>My_GDIPlus_ImageScale

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; New function for DLL call to SetWrapMode on an ImageAttribute

Func My_GDIPlus_ImageAttributesSetWrapMode($hImageAttributes, $iWrapModeType = 0, $iArgb = 0, $bClamp = 0)
	Local $aResult = DllCall($__g_hGDIPDll, "int", "GdipSetImageAttributesWrapMode", "handle", $hImageAttributes, "int", $iWrapModeType, "uint", $iArgb, "bool", $bClamp)
	If @error Then Return SetError(@error, @extended, False)
	If $aResult[0] Then Return SetError(10, $aResult[0], False)

	Return True
EndFunc   ;==>My_GDIPlus_ImageAttributesSetWrapMode

